jQuery(function ($) {
  // Activate
  $('#cs-bot-ai-activate-license').on('click', function () {
    const licenseKey   = $('input[name="cs_bot_ai_settings[license_key]"]').val();
    const licenseEmail = $('input[name="cs_bot_ai_settings[license_email]"]').val();

    $.post(cs_bot_ai_ajax.ajax_url, {
      action: 'cs_bot_ai_activate_license',
      license_key: licenseKey,
      email: licenseEmail,
      nonce: cs_bot_ai_ajax.nonce
    }, function (response) {
      const $msg = $('#cs-bot-ai-license-msg');
      $msg.text(response.data?.message || 'Terjadi kesalahan');
      $msg.css('color', response.success ? 'green' : 'red');
      if (response.success) location.reload();
    }, 'json');
  });

  // Deactivate
  $('#cs-bot-ai-deactivate-license').on('click', function () {
    $.post(cs_bot_ai_ajax.ajax_url, {
      action: 'cs_bot_ai_deactivate_license',
      nonce: cs_bot_ai_ajax.nonce
    }, function (response) {
      const $msg = $('#cs-bot-ai-license-msg');
      $msg.text(response.data?.message || 'Terjadi kesalahan');
      $msg.css('color', response.success ? 'green' : 'red');
      if (response.success) location.reload();
    }, 'json');
  });
});

