<?php
if (!defined('ABSPATH')) {
    exit;
}

class CS_Bot_AI_Shortcode
{

    private static $instance = null;

    public static function get_instance()
    {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct()
    {
        add_shortcode('cs_bot_ai', array($this, 'render_chat_bot'));
        add_action('wp_footer', array($this, 'render_chat_bot_footer'));
    }

    public function render_chat_bot($atts)
    {
        $atts = shortcode_atts(array(
            'position' => 'bottom-right'
        ), $atts);

        ob_start();
        include CS_BOT_AI_PLUGIN_PATH . 'templates/chat-template.php';
        return ob_get_clean();
    }

    public function render_chat_bot_footer()
    {
        $settings = get_option('cs_bot_ai_settings');
        $auto_show = isset($settings['auto_show']) ? $settings['auto_show'] : true;

        if ($auto_show) {
            include CS_BOT_AI_PLUGIN_PATH . 'templates/chat-template.php';
        }
    }
}
