<?php
$settings = get_option('cs_bot_ai_settings');

$chat_button_color = get_option('cs_bot_ai_chat_button_color', '#0073aa');
$title_text_color = get_option('cs_bot_ai_title_text_color', '#000000');
$user_chat_gradient_start = get_option('cs_bot_ai_user_chat_gradient_start', '#4facfe');
$user_chat_gradient_end = get_option('cs_bot_ai_user_chat_gradient_end', '#00f2fe');


$has_user_name = !empty($_SESSION['cs_bot_user_name']);
// ========== END CEK SESSION ==========
?>

<style>
    /* Warna tombol chat floating */
    .cs-bot-ai-floating-btn {
        background: <?php echo esc_attr($chat_button_color); ?>;
        color: #fff;
    }

    /* Warna teks judul chat */
    .cs-bot-ai-chat-header h1 {
        color: <?php echo esc_attr($title_text_color); ?>;
    }

    .cs-bot-ai-chat-header p {
        color: <?php echo esc_attr($title_text_color); ?>;
    }

    /* Contoh: bisa juga ubah ikon kirim atau background pesan user */
    .cs-bot-ai-send-btn {
        background: <?php echo esc_attr($chat_button_color); ?>;
        color: #fff;
    }

    .cs-bot-ai-message.user .cs-bot-ai-message-content {
        background: linear-gradient(135deg, <?php echo esc_attr($user_chat_gradient_start); ?>, <?php echo esc_attr($user_chat_gradient_end); ?>);
        color: #fff;
    }

    /* Styling untuk form user info */
    .cs-bot-ai-user-form {
        padding: 15px;
        background: #f9f9f9;
        border-radius: 10px;
        margin: 10px;
        height: 100%;
    }

    .cs-bot-ai-user-form h3 {
        font-size: 20px;
        margin-top: 0;
        margin-bottom: 15px;
        color: #333;
    }

    .cs-bot-ai-form-group {
        margin-bottom: 12px;
    }

    .cs-bot-ai-form-group label {
        display: block;
        margin-bottom: 5px;
        font-weight: 500;
        color: #555;
    }

    .cs-bot-ai-form-group input {
        width: 100%;
        padding: 10px;
        border: 1px solid #ddd;
        border-radius: 5px;
        font-size: 14px;
    }

    .cs-bot-ai-form-group input:focus {
        outline: none;
        border-color: <?php echo esc_attr($chat_button_color); ?>;
    }

    .cs-bot-ai-submit-btn {
        background: <?php echo esc_attr($chat_button_color); ?>;
        color: white;
        border: none;
        padding: 12px 20px;
        border-radius: 5px;
        cursor: pointer;
        font-weight: 500;
        width: 100%;
    }

    .cs-bot-ai-submit-btn:hover {
        opacity: 0.9;
    }

    .cs-bot-ai-optional {
        color: #888;
        font-size: 12px;
        font-style: italic;
    }

    /* Hide elements by default */
    .cs-bot-ai-chat-input-container,
    #cs-bot-ai-user-form {
        display: none;
    }

    .cs-bot-ai-chat-header {
        background: linear-gradient(135deg, <?php echo esc_attr($user_chat_gradient_start); ?>, <?php echo esc_attr($user_chat_gradient_end); ?>);
    }

    .cs-bot-ai-chat-input-container {
        display: flex;
        align-items: center;
        gap: 10px;
        padding: 15px;
        background: white;
        border-top: 1px solid #e0e0e0;
        position: relative;
        min-height: 70px;
        /* Fixed height untuk prevent shifting */
    }

    .cs-bot-ai-message-input {
        flex: 1;
        padding: 12px 16px;
        border: 2px solid #e8f0fe;
        border-radius: 25px;
        font-size: 14px;
        outline: none;
        resize: none;
        min-height: 20px;
        max-height: 120px;
        overflow-y: auto;
        line-height: 1.4;
        box-sizing: border-box;
    }

    .cs-bot-ai-message-input:focus {
        border-color: <?php echo esc_attr($chat_button_color); ?>;
        box-shadow: 0 0 0 3px rgba(<?php echo esc_attr(hexdec(substr($chat_button_color, 1, 2)) . ',' . hexdec(substr($chat_button_color, 3, 2)) . ',' . hexdec(substr($chat_button_color, 5, 2))); ?>, 0.1);
    }

    .cs-bot-ai-send-btn {
        background: <?php echo esc_attr($chat_button_color); ?>;
        color: white;
        border: none;
        width: 45px;
        height: 45px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        flex-shrink: 0;
        /* Prevent button from shrinking */
        align-self: flex-end;
        /* Tetap di posisi bawah */
        margin-bottom: 5px;
        /* Sedikit spacing dari bawah */
        transition: all 0.3s ease;
    }

    .cs-bot-ai-send-btn:hover {
        opacity: 0.9;
        transform: scale(1.05);
    }

    .cs-bot-ai-send-btn:active {
        transform: scale(0.95);
    }

    /* Untuk handle textarea yang expand */
    .cs-bot-ai-message-input[style*="height"] {
        transition: height 0.2s ease;
    }

    /* Pastikan container tidak berubah height */
    .cs-bot-ai-chat-input-container {
        min-height: 70px;
        align-items: flex-end;
        /* Agar tombol tetap di bawah */
    }

    /* Alternative: Gunakan textarea instead of input untuk better height control */
    .cs-bot-ai-message-input {
        min-height: 20px;
        max-height: 120px;
        padding: 12px 16px;
        line-height: 1.4;
    }
</style>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<div class="cs-bot-ai-container">
    <button class="cs-bot-ai-floating-btn">
        <i class="fas fa-comment-dots"></i>
        <span class="cs-bot-ai-notification-badge" style="display: none;">1</span>
    </button>

    <div class="cs-bot-ai-chat-container">
        <div class="cs-bot-ai-chat-header">
            <h1><?php echo esc_html($settings['chat_title'] ?? 'DeepSeek AI Assistant'); ?></h1>
            <p><?php echo esc_html($settings['chat_subtitle'] ?? 'Powered by DeepSeek API'); ?></p>
            <button class="cs-bot-ai-close-btn" title="Close Chat">
                <i class="fas fa-times"></i>
            </button>
        </div>

        <div class="cs-bot-ai-chat-messages">

        </div>

        <!-- Form untuk mengisi data user -->
        <div class="cs-bot-ai-user-form" id="cs-bot-ai-user-form"
            style="<?php echo $has_user_name ? 'display: none;' : 'display: block;'; ?>">
            <h3>Silakan isi data diri Anda</h3>
            <div class="cs-bot-ai-form-group">
                <label for="cs-bot-ai-user-name">Nama *</label>
                <input type="text" id="cs-bot-ai-user-name" placeholder="Masukkan nama Anda" required>
            </div>
            <div class="cs-bot-ai-form-group">
                <label for="cs-bot-ai-user-email">Email *</label>
                <input type="email" id="cs-bot-ai-user-email" placeholder="Masukkan email Anda" required>
            </div>
            <div class="cs-bot-ai-form-group">
                <label for="cs-bot-ai-user-whatsapp">WhatsApp *</label>
                <input type="tel" id="cs-bot-ai-user-whatsapp" placeholder="Masukkan nomor WhatsApp" required>
            </div>
            <button type="button" class="cs-bot-ai-submit-btn" id="cs-bot-ai-submit-user-info">
                Mulai Chat
            </button>
        </div>

        <div class="cs-bot-ai-typing-indicator">
            <div class="cs-bot-ai-typing-dots">
                <div class="cs-bot-ai-typing-dot"></div>
                <div class="cs-bot-ai-typing-dot"></div>
                <div class="cs-bot-ai-typing-dot"></div>
                <span class="cs-bot-ai-typing-text">Sedang mengetik...</span>
            </div>
        </div>

        <div class="cs-bot-ai-chat-input-container" id="cs-bot-ai-chat-input"
            style="<?php echo $has_user_name ? 'display: flex;' : 'display: none;'; ?>">
            <input
                type="text"
                class="cs-bot-ai-message-input"
                placeholder="Ketik pesan Anda...">
            <button class="cs-bot-ai-send-btn">
                <i class="fas fa-paper-plane"></i>
            </button>
        </div>
    </div>
</div>